#ifndef __H_VULKAN_DEVICE_CONTEXT_
#define __H_VULKAN_DEVICE_CONTEXT_

#pragma once


#include<vulkan/vulkan.h>

#include<map>
#include<vector>
#include<string>
#include<xcb/xcb.h>

class VulkanDC
{
public:
    ~VulkanDC();

	static VulkanDC *Get();



	class Device{
	public:

		typedef std::string Name;

		struct SwapchainBuffers {
				VkImage image;
				VkCommandBuffer cmd;
				VkImageView view;
			};



		Device();
		Device(const VkPhysicalDevice &inDevice);
		~Device();

		uint32_t getBestMemoryType(uint32_t inType, VkFlags inFlags);


		class Queue{
		public:

			typedef std::string Name;
			typedef uint32_t NodeID;
			typedef std::map<Name, Queue*> Map;
			typedef uint32_t CommandBufferID;
			typedef std::map<CommandBufferID, VkCommandBuffer> CommandBufferMap;

			Queue();
			Queue(Name &inName,NodeID inNodeID);
			Queue(const Queue& inOther);
			~Queue();

			void initQueue(VulkanDC::Device *inDevice);

			inline VulkanDC::Device *getDevice() const { return m_device; }
			inline VkCommandPool &getCommandPool() { return m_command_pool; }

			void createCommandBuffer(
				VkCommandBuffer *outBuffer,
				VkCommandBufferLevel inLevel = VK_COMMAND_BUFFER_LEVEL_PRIMARY);

			bool createAndCacheCommandBuffer(
				const CommandBufferID &inID,
				VkCommandBuffer *outBuffer,
				VkCommandBufferLevel inlevel = VK_COMMAND_BUFFER_LEVEL_PRIMARY
				);

			void beginCommandBuffer(
				VkCommandBuffer *inBuffer,
				VkCommandBufferUsageFlags inFlags = VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT,
				VkCommandBufferLevel inLevel = VK_COMMAND_BUFFER_LEVEL_PRIMARY,
				VkFramebuffer inFBO  = VK_NULL_HANDLE,
				VkRenderPass inRP = VK_NULL_HANDLE

				);

			void beginCommandBuffer(
				CommandBufferID &inID,
				VkCommandBuffer *outBuffer,
				VkCommandBufferUsageFlags inFlags = VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT,
				VkCommandBufferLevel inLevel = VK_COMMAND_BUFFER_LEVEL_PRIMARY,
				VkFramebuffer inFBO = VK_NULL_HANDLE,
				VkRenderPass inRP = VK_NULL_HANDLE
				);
			
			void resetCommandBuffer(CommandBufferID &inID);
			void flushCommandBuffer(CommandBufferID &inID, VkFence *inFence = NULL, bool inDestroy = true);
			void flushPersistentBuffer(CommandBufferID &inID, VkFence *inFence = NULL);

			VkCommandBuffer getCachedCommandBuffer(CommandBufferID &inID);
			void destroyCachedCommandBuffer(CommandBufferID &inID);

			inline VkQueue &getVKQueue(){ return m_queue; }

		private:

			Name m_name;
			NodeID m_node_id;
			VkQueue m_queue;
			VulkanDC::Device *m_device;

			VkCommandPool m_command_pool;
			CommandBufferMap m_cached_buffers;



		};

		typedef std::vector<Device*> List;

		inline VkDevice &getVKDevice(){ return m_device; }

		inline VkPhysicalDevice &getPhysicalDevice(){ return m_physical_device;}

		inline uint32_t getQueueCount() const { return m_queue_count; }

		VulkanDC::Device::Queue *getQueue(VulkanDC::Device::Queue::Name &inName);
		
        VulkanDC::Device::Queue *createGraphicsQueue(VulkanDC::Device::Queue::Name &inName, VulkanDC::Device::Queue::NodeID inID = 0);

		Queue *newQueue(Queue::Name &inName, Queue::NodeID &inNodeID);

		void initWSI(xcb_connection_t *inConnection, xcb_screen_t *inScreen, xcb_drawable_t inWindow);

		void initWSIBuffers(VkCommandBuffer &inInitCommand);

		void waitIdle();

		uint32_t  present(Queue *inQueue, VkCommandBuffer *inBuffers);

		VkFormat getFormat() { return m_format; }

		void setDisplayDimensions(uint32_t inWidth, uint32_t inHeight){
			m_width = inWidth;
			m_height = inHeight;
		}

		uint32_t getDisplayWidth() { return m_width; }
		uint32_t getDisplayHeight() { return m_height; }

		SwapchainBuffers *getSCBuffers(){
			return m_swap_chain_buffers;
		}

	private:
		VkPhysicalDeviceProperties m_device_properties;
        VkQueueFamilyProperties *m_queue_properties;
		VkPhysicalDeviceMemoryProperties m_memory_properties;

		uint32_t m_queue_count;
		Queue::Map m_queues;
		VkPhysicalDevice m_physical_device;
		VkDevice m_device;
		Name m_name;


		char *m_extension_names[64];
		uint32_t m_extension_count;

		void initDevice();


		VkSwapchainKHR m_swapchain;
		uint32_t m_swapchain_image_count;
		SwapchainBuffers *m_swap_chain_buffers;
		uint32_t m_current_swap_chain_buffer;

		VkFormat m_format;
		VkColorSpaceKHR m_color_space;

		xcb_connection_t *m_xcbconn;
		xcb_screen_t *m_xcbscreen;
		xcb_drawable_t m_xcbwin;
		VkSurfaceKHR m_surface;

		uint32_t m_graphics_queue_index;

		uint32_t m_width;
		uint32_t m_height;


	};

	


	void initDC(const VkInstance &inInstance);

	uint32_t getQueueCount(uint32_t inDeviceID = 0);
	inline uint32_t getDeviceCount() const { return m_device_count; }

	VulkanDC::Device *getDevice(uint32_t inDeviceID = 0);

	VulkanDC::Device *getDefaultDevice() { return m_default_device; }
	VulkanDC::Device::Queue *getDefaultQueue() { return m_default_queue; }
	void setDefaultDevice(VulkanDC::Device *inDevice) { m_default_device = inDevice; }

	void setDefaultQueue(VulkanDC::Device::Queue *inQueue) { m_default_queue = inQueue; }

    VulkanDC::Device::Queue *getQueueForGraphics(VulkanDC::Device::Queue::Name &queueName,VkFormat &outFormat,VulkanDC::Device::Queue::NodeID inID = 0);



	

private:
	VulkanDC();


	bool m_has_instance;
	VkInstance m_vk_instance;
	VkPhysicalDevice *m_physical_devices;
	uint32_t m_device_count;

	Device::List m_devices;

	Device *m_default_device;
	Device::Queue *m_default_queue;



	void initDevices();

	Device *newDevice(const VkPhysicalDevice &inDevice);


};

#endif
