#ifndef __H_VULKAN_APP_CONTEXT_
#define __H_VULKAN_APP_CONTEXT_



#include<vulkan/vulkan.h>
#include"vkaUtils.h"
#include"VkeNodeData.h"
#include"VkeMaterial.h"
#include"RenderContext.h"
#include"VkeMesh.h"
#include"nv_math/nv_math.h"
#include"VkeSceneAnimation.h"



#define TEXTURE_COUNT 2

class VkeMesh;
class VkeDeferredRenderer;
class VkeRenderer;


#pragma once
class VulkanAppContext
{
public:
	VulkanAppContext();
	~VulkanAppContext();

	static VulkanAppContext *GetInstance();

	void initAppContext();
	void initQueue();

	void initRenderer();

	void loadVKSScene(std::string &inFileName);
	void addVKSNode(VKSFile *inFile, uint32_t &inNodesProcessed, Node *parentNode = NULL);

	void render();

	bool initPrograms();

	void resize(uint32_t inWidth, uint32_t inHeight);
	VkeMaterial *getMaterial(VkeMaterial::ID inID);

	nv_math::vec4f getRotorPos(){
		nv_math::vec4f wpos(0.0,0.0,-1.0,1.0);
		return m_rotor_node->getNode()->worldPosition(wpos);
	}

	VkeVBO *getVBO(){ return &m_global_vbo; }
	VkeIBO *getIBO(){ return &m_global_ibo; }

	void setCameraMatrix(nv_math::mat4f &inMat);

	float getOpacity(uint32_t inMatID){
		return m_materials.getMaterial(inMatID)->getBackingStore()->opacity;

	}

	VkInstance &getVKInstance() { return m_vk_instance;}

	void initWSI(xcb_connection_t *inConnection, xcb_screen_t *inScreen, xcb_drawable_t inWindow);

	void shutDown();

	PFN_vkGetPhysicalDeviceSurfaceSupportKHR fpGetPhysicalDeviceSurfaceSupportKHR;
	PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR fpGetPhysicalDeviceSurfaceCapabilitiesKHR;
	PFN_vkGetPhysicalDeviceSurfaceFormatsKHR fpGetPhysicalDeviceSurfaceFormatsKHR;
	PFN_vkGetPhysicalDeviceSurfacePresentModesKHR fpGetPhysicalDeviceSurfacePresentModesKHR;
	PFN_vkCreateSwapchainKHR fpCreateSwapchainKHR;
	PFN_vkDestroySwapchainKHR fpDestroySwapchainKHR;
	PFN_vkGetSwapchainImagesKHR fpGetSwapchainImagesKHR;
	PFN_vkAcquireNextImageKHR fpAcquireNextImageKHR;
	PFN_vkQueuePresentKHR fpQueuePresentKHR;

private:


	VkInstance				m_vk_instance;

    uint32_t                m_width;
    uint32_t                m_height;



	VkFormat						m_surface_format;
    VkeRenderer                     *m_renderer;
    VkeNodeData::List               m_node_data;
    VkeMesh::List                   m_mesh_data;
    Scene                           *m_scene_graph;
    VkeMaterial::List               m_materials;
	VkeNodeData						*m_rotor_node;

	float m_rot_y;
	double m_current_time;

	bool							m_ready;
	uint32_t						m_current_frame;
	VkeSceneAnimation				m_animation;

	VkeVBO							m_global_vbo;
	VkeIBO							m_global_ibo;

	


public:


};


#endif
